<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface RawmaterialssuppliersDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Rawmaterialssuppliers 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param rawmaterialssupplier primary key
 	 */
	public function delete($rawmaterialssupplierid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Rawmaterialssuppliers rawmaterialssupplier
 	 */
	public function insert($rawmaterialssupplier);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Rawmaterialssuppliers rawmaterialssupplier
 	 */
	public function update($rawmaterialssupplier);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByRawmaterialssuppliername($value);

	public function queryByRawmaterialssupplierdebt($value);

	public function queryByRawmaterialssupplieraddress($value);

	public function queryByRawmaterialssuppliertele($value);

	public function queryByRawmaterialssuppliercomment($value);

	public function queryByTempdelete($value);

	public function queryByCurrentdate($value);


	public function deleteByRawmaterialssuppliername($value);

	public function deleteByRawmaterialssupplierdebt($value);

	public function deleteByRawmaterialssupplieraddress($value);

	public function deleteByRawmaterialssuppliertele($value);

	public function deleteByRawmaterialssuppliercomment($value);

	public function deleteByTempdelete($value);

	public function deleteByCurrentdate($value);


}
?>