<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2018-05-22 14:34
 */
interface RestaurantrawdestructionDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Restaurantrawdestruction 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param restaurantrawdestruction primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Restaurantrawdestruction restaurantrawdestruction
 	 */
	public function insert($restaurantrawdestruction);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Restaurantrawdestruction restaurantrawdestruction
 	 */
	public function update($restaurantrawdestruction);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByStoreid($value);

	public function queryByProductid($value);

	public function queryByQuantity($value);

	public function queryByConditions($value);

	public function queryBySysdate($value);

	public function queryByUserid($value);


	public function deleteByStoreid($value);

	public function deleteByProductid($value);

	public function deleteByQuantity($value);

	public function deleteByConditions($value);

	public function deleteBySysdate($value);

	public function deleteByUserid($value);


}
?>