<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2023-12-07 03:04
 */
interface SavecloseDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Saveclose 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param saveclose primary key
 	 */
	public function delete($savecloseid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Saveclose saveclose
 	 */
	public function insert($saveclose);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Saveclose saveclose
 	 */
	public function update($saveclose);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryBySaveidfrom($value);

	public function queryBySaveidto($value);

	public function queryBySaveclosevalue($value);

	public function queryBySaveclosedate($value);

	public function queryByUserid($value);

	public function queryByConditions($value);

	public function queryByDailyentryid($value);

	public function queryByComment($value);

	public function queryByCurrencyId($value);

	public function queryByConversionFactor($value);

	public function queryByConversionFactorFrom($value);

	public function queryByConversionFactorTo($value);

	public function queryBySaveclosevalueInCurrency($value);


	public function deleteBySaveidfrom($value);

	public function deleteBySaveidto($value);

	public function deleteBySaveclosevalue($value);

	public function deleteBySaveclosedate($value);

	public function deleteByUserid($value);

	public function deleteByConditions($value);

	public function deleteByDailyentryid($value);

	public function deleteByComment($value);

	public function deleteByCurrencyId($value);

	public function deleteByConversionFactor($value);

	public function deleteByConversionFactorFrom($value);

	public function deleteByConversionFactorTo($value);

	public function deleteBySaveclosevalueInCurrency($value);


}
?>