<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2020-12-14 16:01
 */
interface Tamweenda3mstatusDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Tamweenda3mstatus 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param tamweenda3mstatu primary key
 	 */
	public function delete($id);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Tamweenda3mstatus tamweenda3mstatu
 	 */
	public function insert($tamweenda3mstatu);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Tamweenda3mstatus tamweenda3mstatu
 	 */
	public function update($tamweenda3mstatu);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByClientid($value);

	public function queryByMonth($value);

	public function queryByTamweenStatus($value);

	public function queryByDa3mStatus($value);

	public function queryByUserid($value);

	public function queryBySysdate($value);

	public function queryByDel($value);


	public function deleteByClientid($value);

	public function deleteByMonth($value);

	public function deleteByTamweenStatus($value);

	public function deleteByDa3mStatus($value);

	public function deleteByUserid($value);

	public function deleteBySysdate($value);

	public function deleteByDel($value);


}
?>