<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
interface UserDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return User 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param user primary key
 	 */
	public function delete($userid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param User user
 	 */
	public function insert($user);
	
	/**
 	 * Update record in table
 	 *
 	 * @param User user
 	 */
	public function update($user);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUsername($value);

	public function queryByPassword($value);

	public function queryByUsergroupid($value);

	public function queryByEmployeename($value);

	public function queryByCurrentdate($value);

	public function queryByConditions($value);

	public function queryBySaveid($value);


	public function deleteByUsername($value);

	public function deleteByPassword($value);

	public function deleteByUsergroupid($value);

	public function deleteByEmployeename($value);

	public function deleteByCurrentdate($value);

	public function deleteByConditions($value);

	public function deleteBySaveid($value);


}
?>