<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2012-07-26 17:38
 */
interface WithdrawalsDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Withdrawals 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param withdrawal primary key
 	 */
	public function delete($withdrawalid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Withdrawals withdrawal
 	 */
	public function insert($withdrawal);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Withdrawals withdrawal
 	 */
	public function update($withdrawal);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByWithdrawalvalue($value);

	public function queryByWithdrawalcomment($value);

	public function queryByCurrentdate($value);

	public function queryByTempdelete($value);


	public function deleteByWithdrawalvalue($value);

	public function deleteByWithdrawalcomment($value);

	public function deleteByCurrentdate($value);

	public function deleteByTempdelete($value);


}
?>