<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
interface WorkstationworkerDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Workstationworker 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param workstationworker primary key
 	 */
	public function delete($employeeid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Workstationworker workstationworker
 	 */
	public function insert($workstationworker);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Workstationworker workstationworker
 	 */
	public function update($workstationworker);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByWorkstationid($value);

	public function queryByEmployeeid($value);

	public function queryByWorkhours($value);

	public function queryByEfficiency($value);


	public function deleteByWorkstationid($value);

	public function deleteByEmployeeid($value);

	public function deleteByWorkhours($value);

	public function deleteByEfficiency($value);


}
?>