<?php

/**
 * Class that operate on table 'kempiala'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class KempialaMySqlDAO implements KempialaDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return KempialaMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM kempiala WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM kempiala';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM kempiala ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param kempiala primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM kempiala WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param KempialaMySql kempiala
     */
    public function insert($kempiala) {
        $sql = 'INSERT INTO kempiala (clientID, recievingdate, value, clientcomment, selling, expiredate, supplierID, sellingdate, conditions, suppliercomment, dailyentryid) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($kempiala->clientID);
        $sqlQuery->set($kempiala->recievingdate);
        $sqlQuery->set($kempiala->value);
        $sqlQuery->set($kempiala->clientcomment);
        $sqlQuery->setNumber($kempiala->selling);
        $sqlQuery->set($kempiala->expiredate);
        $sqlQuery->setNumber($kempiala->supplierID);
        $sqlQuery->set($kempiala->sellingdate);
        $sqlQuery->setNumber($kempiala->conditions);
        $sqlQuery->set($kempiala->suppliercomment);
        $sqlQuery->setNumber($kempiala->dailyentryid);

        $id = $this->executeInsert($sqlQuery);
        $kempiala->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param KempialaMySql kempiala
     */
    public function update($kempiala) {
        $sql = 'UPDATE kempiala SET clientID = ?, recievingdate = ?, value = ?, clientcomment = ?, selling = ?, expiredate = ?, supplierID = ?, sellingdate = ?, conditions = ?, suppliercomment = ?, dailyentryid = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($kempiala->clientID);
        $sqlQuery->set($kempiala->recievingdate);
        $sqlQuery->set($kempiala->value);
        $sqlQuery->set($kempiala->clientcomment);
        $sqlQuery->setNumber($kempiala->selling);
        $sqlQuery->set($kempiala->expiredate);
        $sqlQuery->setNumber($kempiala->supplierID);
        $sqlQuery->set($kempiala->sellingdate);
        $sqlQuery->setNumber($kempiala->conditions);
        $sqlQuery->set($kempiala->suppliercomment);
        $sqlQuery->setNumber($kempiala->dailyentryid);

        $sqlQuery->setNumber($kempiala->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM kempiala';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByClientID($value) {
        $sql = 'SELECT * FROM kempiala WHERE clientID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByRecievingdate($value) {
        $sql = 'SELECT * FROM kempiala WHERE recievingdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByValue($value) {
        $sql = 'SELECT * FROM kempiala WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByClientcomment($value) {
        $sql = 'SELECT * FROM kempiala WHERE clientcomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySelling($value) {
        $sql = 'SELECT * FROM kempiala WHERE selling = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByExpiredate($value) {
        $sql = 'SELECT * FROM kempiala WHERE expiredate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySupplierID($value) {
        $sql = 'SELECT * FROM kempiala WHERE supplierID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellingdate($value) {
        $sql = 'SELECT * FROM kempiala WHERE sellingdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBycondition($value) {
        $sql = 'SELECT * FROM kempiala WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySuppliercomment($value) {
        $sql = 'SELECT * FROM kempiala WHERE suppliercomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByClientID($value) {
        $sql = 'DELETE FROM kempiala WHERE clientID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByRecievingdate($value) {
        $sql = 'DELETE FROM kempiala WHERE recievingdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByValue($value) {
        $sql = 'DELETE FROM kempiala WHERE value = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByClientcomment($value) {
        $sql = 'DELETE FROM kempiala WHERE clientcomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySelling($value) {
        $sql = 'DELETE FROM kempiala WHERE selling = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByExpiredate($value) {
        $sql = 'DELETE FROM kempiala WHERE expiredate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySupplierID($value) {
        $sql = 'DELETE FROM kempiala WHERE supplierID = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellingdate($value) {
        $sql = 'DELETE FROM kempiala WHERE sellingdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBycondition($value) {
        $sql = 'DELETE FROM kempiala WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySuppliercomment($value) {
        $sql = 'DELETE FROM kempiala WHERE suppliercomment = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return KempialaMySql
     */
    protected function readRow($row) {
        $kempiala = new Kempiala();

        $kempiala->id = isset($row['id']) ? $row['id'] : '';
        $kempiala->clientID = isset($row['clientID']) ? $row['clientID'] : '';
        $kempiala->recievingdate = isset($row['recievingdate']) ? $row['recievingdate'] : '';
        $kempiala->value = isset($row['value']) ? $row['value'] : '';
        $kempiala->clientcomment = isset($row['clientcomment']) ? $row['clientcomment'] : '';
        $kempiala->selling = isset($row['selling']) ? $row['selling'] : '';
        $kempiala->expiredate = isset($row['expiredate']) ? $row['expiredate'] : '';
        $kempiala->supplierID = isset($row['supplierID']) ? $row['supplierID'] : '';
        $kempiala->sellingdate = isset($row['sellingdate']) ? $row['sellingdate'] : '';
        $kempiala->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $kempiala->suppliercomment = isset($row['suppliercomment']) ? $row['suppliercomment'] : '';
        $kempiala->clientname = isset($row['clientname']) ? $row['clientname'] : '';
        $kempiala->suppliername = isset($row['suppliername']) ? $row['suppliername'] : '';
        $kempiala->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';




        return $kempiala;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return KempialaMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>