<?php

/**
 * Class that operate on table 'quickprofitday'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2019-01-21 13:45
 */
class QuickprofitdayMySqlDAO implements QuickprofitdayDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return QuickprofitdayMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM quickprofitday WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM quickprofitday';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM quickprofitday ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param quickprofitday primary key
     */
    public function delete($id) {
        $sql = 'DELETE FROM quickprofitday WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param QuickprofitdayMySql quickprofitday
     */
    public function insert($quickprofitday) {
        $sql = 'INSERT INTO quickprofitday (theDate, sellVal, sellCostBuyPrice, sellCostLastBuyPrice, sellCostMeanBuyPrice, sellCostLastBuyPricewithDiscount, sellCostMeanBuyPricewithDiscount, returnSellVal, returnSellCostBuyPrice, returnSellCostLastBuyPrice, returnSellCostMeanBuyPrice, returnSellCostLastBuyPricewithDiscount, returnSellCostMeanBuyPricewithDiscount) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($quickprofitday->theDate);
        $sqlQuery->set($quickprofitday->sellVal);
        $sqlQuery->set($quickprofitday->sellCostBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->returnSellVal);
        $sqlQuery->set($quickprofitday->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->returnSellCostMeanBuyPricewithDiscount);

        $id = $this->executeInsert($sqlQuery);
        $quickprofitday->id = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param QuickprofitdayMySql quickprofitday
     */
    public function update($quickprofitday) {
        $sql = 'UPDATE quickprofitday SET theDate = ?, sellVal = ?, sellCostBuyPrice = ?, sellCostLastBuyPrice = ?, sellCostMeanBuyPrice = ?, sellCostLastBuyPricewithDiscount = ?, sellCostMeanBuyPricewithDiscount = ?, returnSellVal = ?, returnSellCostBuyPrice = ?, returnSellCostLastBuyPrice = ?, returnSellCostMeanBuyPrice = ?, returnSellCostLastBuyPricewithDiscount = ?, returnSellCostMeanBuyPricewithDiscount = ? WHERE id = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($quickprofitday->theDate);
        $sqlQuery->set($quickprofitday->sellVal);
        $sqlQuery->set($quickprofitday->sellCostBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostLastBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitday->sellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->sellCostMeanBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->returnSellVal);
        $sqlQuery->set($quickprofitday->returnSellCostBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostLastBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostMeanBuyPrice);
        $sqlQuery->set($quickprofitday->returnSellCostLastBuyPricewithDiscount);
        $sqlQuery->set($quickprofitday->returnSellCostMeanBuyPricewithDiscount);

        $sqlQuery->setNumber($quickprofitday->id);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM quickprofitday';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTheDate($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellVal($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellVal($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPrice($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'SELECT * FROM quickprofitday WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTheDate($value) {
        $sql = 'DELETE FROM quickprofitday WHERE theDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellVal($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteBySellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitday WHERE sellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellVal($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellVal = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellCostBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellCostLastBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPrice($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellCostMeanBuyPrice = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostLastBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellCostLastBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByReturnSellCostMeanBuyPricewithDiscount($value) {
        $sql = 'DELETE FROM quickprofitday WHERE returnSellCostMeanBuyPricewithDiscount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return QuickprofitdayMySql
     */
    protected function readRow($row) {
        $quickprofitday = new Quickprofitday();

        $quickprofitday->id = $row['id'];
        $quickprofitday->theDate = $row['theDate'];
        $quickprofitday->sellVal = $row['sellVal'];
        $quickprofitday->sellCostBuyPrice = $row['sellCostBuyPrice'];
        $quickprofitday->sellCostLastBuyPrice = $row['sellCostLastBuyPrice'];
        $quickprofitday->sellCostMeanBuyPrice = $row['sellCostMeanBuyPrice'];
        $quickprofitday->sellCostLastBuyPricewithDiscount = $row['sellCostLastBuyPricewithDiscount'];
        $quickprofitday->sellCostMeanBuyPricewithDiscount = $row['sellCostMeanBuyPricewithDiscount'];
        $quickprofitday->sellCostOverAllAveragePrice = $row['sellCostOverAllAveragePrice'];
        $quickprofitday->returnSellVal = $row['returnSellVal'];
        $quickprofitday->returnSellCostBuyPrice = $row['returnSellCostBuyPrice'];
        $quickprofitday->returnSellCostLastBuyPrice = $row['returnSellCostLastBuyPrice'];
        $quickprofitday->returnSellCostMeanBuyPrice = $row['returnSellCostMeanBuyPrice'];
        $quickprofitday->returnSellCostLastBuyPricewithDiscount = $row['returnSellCostLastBuyPricewithDiscount'];
        $quickprofitday->returnSellCostMeanBuyPricewithDiscount = $row['returnSellCostMeanBuyPricewithDiscount'];
        $quickprofitday->returnSellCostOverAllAveragePrice = $row['returnSellCostOverAllAveragePrice'];

        return $quickprofitday;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return QuickprofitdayMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>