<?php

/**
 * Class that operate on table 'sparepartstore'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-09-28 11:55
 */
class SparepartstoreMySqlDAO implements SparepartstoreDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return SparepartstoreMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM sparepartstore WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM sparepartstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM sparepartstore ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param sparepartstore primary key
     */
    public function delete($sparepartstoreId) {
        $sql = 'DELETE FROM sparepartstore WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($sparepartstoreId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param SparepartstoreMySql sparepartstore
     */
    public function insert($sparepartstore) {
        $sql = 'INSERT INTO sparepartstore (storeName, storeDate, storeDescription, conditions, userId) VALUES (?, ?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sparepartstore->storeName);
        $sqlQuery->set($sparepartstore->storeDate);
        $sqlQuery->setString2($sparepartstore->storeDescription);
        $sqlQuery->setNumber($sparepartstore->conditions);
        $sqlQuery->setNumber($sparepartstore->userId);

        $id = $this->executeInsert($sqlQuery);
        $sparepartstore->sparepartstoreId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param SparepartstoreMySql sparepartstore
     */
    public function update($sparepartstore) {
        $sql = 'UPDATE sparepartstore SET storeName = ?, storeDate = ?, storeDescription = ?, conditions = ?, userId = ? WHERE sparepartstoreId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($sparepartstore->storeName);
        $sqlQuery->set($sparepartstore->storeDate);
        $sqlQuery->setString2($sparepartstore->storeDescription);
        $sqlQuery->setNumber($sparepartstore->conditions);
        $sqlQuery->setNumber($sparepartstore->userId);

        $sqlQuery->setNumber($sparepartstore->sparepartstoreId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM sparepartstore';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreName($value) {
        $sql = 'SELECT * FROM sparepartstore WHERE storeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreDate($value) {
        $sql = 'SELECT * FROM sparepartstore WHERE storeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreDescription($value) {
        $sql = 'SELECT * FROM sparepartstore WHERE storeDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value) {
        $sql = 'SELECT * FROM sparepartstore WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserId($value) {
        $sql = 'SELECT * FROM sparepartstore WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreName($value) {
        $sql = 'DELETE FROM sparepartstore WHERE storeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreDate($value) {
        $sql = 'DELETE FROM sparepartstore WHERE storeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreDescription($value) {
        $sql = 'DELETE FROM sparepartstore WHERE storeDescription = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value) {
        $sql = 'DELETE FROM sparepartstore WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserId($value) {
        $sql = 'DELETE FROM sparepartstore WHERE userId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return SparepartstoreMySql
     */
    protected function readRow($row) {
        $sparepartstore = new Sparepartstore();

        $sparepartstore->sparepartstoreId = isset($row['sparepartstoreId']) ? $row['sparepartstoreId'] : '';
        $sparepartstore->storeName = isset($row['storeName']) ? $row['storeName'] : '';
        $sparepartstore->storeDate = isset($row['storeDate']) ? $row['storeDate'] : '';
        $sparepartstore->storeDescription = isset($row['storeDescription']) ? $row['storeDescription'] : '';
        $sparepartstore->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $sparepartstore->userId = isset($row['userId']) ? $row['userId'] : '';

        return $sparepartstore;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return SparepartstoreMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>