<?php

/**
 * Class that operate on table 'stagestep'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-08 10:32
 */
class StagestepMySqlDAO implements StagestepDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StagestepMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM stagestep WHERE stagestepId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM stagestep';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM stagestep ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param stagestep primary key
     */
    public function delete($stagestepId) {
        $sql = 'DELETE FROM stagestep WHERE stagestepId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($stagestepId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StagestepMySql stagestep
     */
    public function insert($stagestep) {
        $sql = 'INSERT INTO stagestep (stageId, stepno, operationId) VALUES (?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($stagestep->stageId);
        $sqlQuery->setNumber($stagestep->stepno);
        $sqlQuery->setNumber($stagestep->operationId);

        $id = $this->executeInsert($sqlQuery);
        $stagestep->stagestepId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StagestepMySql stagestep
     */
    public function update($stagestep) {
        $sql = 'UPDATE stagestep SET stageId = ?, stepno = ?, operationId = ? WHERE stagestepId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($stagestep->stageId);
        $sqlQuery->setNumber($stagestep->stepno);
        $sqlQuery->setNumber($stagestep->operationId);

        $sqlQuery->setNumber($stagestep->stagestepId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM stagestep';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStageId($value) {
        $sql = 'SELECT * FROM stagestep WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStepno($value) {
        $sql = 'SELECT * FROM stagestep WHERE stepno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByOperationId($value) {
        $sql = 'SELECT * FROM stagestep WHERE operationId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStageId($value) {
        $sql = 'DELETE FROM stagestep WHERE stageId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStepno($value) {
        $sql = 'DELETE FROM stagestep WHERE stepno = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByOperationId($value) {
        $sql = 'DELETE FROM stagestep WHERE operationId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StagestepMySql
     */
    protected function readRow($row) {
        $stagestep = new Stagestep();

        $stagestep->stagestepId = isset($row['stagestepId']) ? $row['stagestepId'] : '';
        $stagestep->stageId = isset($row['stageId']) ? $row['stageId'] : '';
        $stagestep->stepno = isset($row['stepno']) ? $row['stepno'] : '';
        $stagestep->operationId = isset($row['operationId']) ? $row['operationId'] : '';

        return $stagestep;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StagestepMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>