<?php

/**
 * Class that operate on table 'storemovement'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class StoremovementMySqlDAO implements StoremovementDAO
{

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return StoremovementMySql
     */
    public function load($id)
    {
        $sql = 'SELECT * FROM storemovement WHERE transferproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll()
    {
        $sql = 'SELECT * FROM storemovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn)
    {
        $sql = 'SELECT * FROM storemovement ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param storemovement primary key
     */
    public function delete($transferproductid)
    {
        $sql = 'DELETE FROM storemovement WHERE transferproductid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($transferproductid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param StoremovementMySql storemovement
     */
    public function insert($storemovement)
    {
        $sql = 'INSERT INTO storemovement (storeidfrom, storeidto, productid, transferproductamount, transferproductdate, userid, conditions ,operationnum,driverid,drivertimeout,driverdate,delivererid,deliverdate,storetype,priceType,price,sizeid,colorid,expireDate,comment,maincomment,recieveType,recieveUserid,recieveTime,deloperationnum) VALUES (?, ?, ?, ?, ?, ?, ?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storemovement->storeidfrom);
        $sqlQuery->setNumber($storemovement->storeidto);
        $sqlQuery->setNumber($storemovement->productid);
        $sqlQuery->setNumber($storemovement->transferproductamount);
        $sqlQuery->set($storemovement->transferproductdate);
        $sqlQuery->setNumber($storemovement->userid);
        $sqlQuery->setNumber($storemovement->conditions);
        $sqlQuery->setNumber($storemovement->operationnum);
        $sqlQuery->setNumber((int) $storemovement->driverid);
        $sqlQuery->setNumber((int) $storemovement->drivertimeout);
        $sqlQuery->set($storemovement->driverdate);
        $sqlQuery->setNumber((int) $storemovement->delivererid);
        $sqlQuery->set($storemovement->deliverdate);
        $sqlQuery->setNumber($storemovement->storetype);
        $sqlQuery->set($storemovement->priceType);
        $sqlQuery->setNumber((int) $storemovement->price);
        $sqlQuery->setNumber((int) $storemovement->sizeid);
        $sqlQuery->setNumber((int) $storemovement->colorid);
        $sqlQuery->set($storemovement->expireDate);
        $sqlQuery->set($storemovement->comment);
        $sqlQuery->set($storemovement->maincomment);
        $sqlQuery->setNumber((int) $storemovement->recieveType);
        $sqlQuery->setNumber((int) $storemovement->recieveUserid);
        $sqlQuery->set($storemovement->recieveTime);
        $sqlQuery->setNumber((int) $storemovement->deloperationnum);

        $id = $this->executeInsert($sqlQuery);
        $storemovement->transferproductid = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param StoremovementMySql storemovement
     */
    public function update($storemovement)
    {
        $sql = 'UPDATE storemovement SET storeidfrom = ?, storeidto = ?, productid = ?, transferproductamount = ?, transferproductdate = ?, userid = ?, conditions = ?,driverid = ?,drivertimeout = ?,driverdate = ?,delivererid = ?,deliverdate = ?,storetype = ?,priceType = ?,price = ?,sizeid = ?,colorid = ?,expireDate=?,comment=?,maincomment=?,recieveType=?,recieveUserid=?,recieveTime=? WHERE transferproductid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($storemovement->storeidfrom);
        $sqlQuery->setNumber($storemovement->storeidto);
        $sqlQuery->setNumber($storemovement->productid);
        $sqlQuery->setNumber($storemovement->transferproductamount);
        $sqlQuery->set($storemovement->transferproductdate);
        $sqlQuery->setNumber($storemovement->userid);
        $sqlQuery->setNumber($storemovement->conditions);
        $sqlQuery->setNumber((int) $storemovement->driverid);
        $sqlQuery->setNumber((int) $storemovement->drivertimeout);
        $sqlQuery->set($storemovement->driverdate);
        $sqlQuery->setNumber((int) $storemovement->delivererid);
        $sqlQuery->set($storemovement->deliverdate);
        $sqlQuery->setNumber($storemovement->storetype);
        $sqlQuery->set($storemovement->priceType);
        $sqlQuery->setNumber($storemovement->price);
        $sqlQuery->setNumber((int) $storemovement->sizeid);
        $sqlQuery->setNumber((int) $storemovement->colorid);
        $sqlQuery->set($storemovement->expireDate);
        $sqlQuery->set($storemovement->comment);
        $sqlQuery->set($storemovement->maincomment);
        $sqlQuery->setNumber((int) $storemovement->recieveType);
        $sqlQuery->setNumber((int) $storemovement->recieveUserid);
        $sqlQuery->set($storemovement->recieveTime);

        $sqlQuery->setNumber($storemovement->transferproductid);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean()
    {
        $sql = 'DELETE FROM storemovement';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByStoreidfrom($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE storeidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByStoreidto($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE storeidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByProductid($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransferproductamount($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE transferproductamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTransferproductdate($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE transferproductdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByUserid($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByConditions($value)
    {
        $sql = 'SELECT * FROM storemovement WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByStoreidfrom($value)
    {
        $sql = 'DELETE FROM storemovement WHERE storeidfrom = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByStoreidto($value)
    {
        $sql = 'DELETE FROM storemovement WHERE storeidto = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByProductid($value)
    {
        $sql = 'DELETE FROM storemovement WHERE productid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransferproductamount($value)
    {
        $sql = 'DELETE FROM storemovement WHERE transferproductamount = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTransferproductdate($value)
    {
        $sql = 'DELETE FROM storemovement WHERE transferproductdate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByUserid($value)
    {
        $sql = 'DELETE FROM storemovement WHERE userid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByConditions($value)
    {
        $sql = 'DELETE FROM storemovement WHERE conditions = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return StoremovementMySql
     */
    protected function readRow($row)
    {
        $storemovement = new Storemovement();

        $storemovement->transferproductid = isset($row['transferproductid']) ? $row['transferproductid'] : '';
        $storemovement->storeidfrom = isset($row['storeidfrom']) ? $row['storeidfrom'] : '';
        $storemovement->storeidto = isset($row['storeidto']) ? $row['storeidto'] : '';
        $storemovement->productid = isset($row['productid']) ? $row['productid'] : '';
        $storemovement->transferproductamount = isset($row['transferproductamount']) ? (float) $row['transferproductamount'] : '';
        $storemovement->transferproductdate = isset($row['transferproductdate']) ? $row['transferproductdate'] : '';
        $storemovement->userid = isset($row['userid']) ? $row['userid'] : '';
        $storemovement->conditions = isset($row['conditions']) ? $row['conditions'] : '';

        $storemovement->comment = isset($row['comment']) ? $row['comment'] : '';
        $storemovement->maincomment = isset($row['maincomment']) ? $row['maincomment'] : '';
        $storemovement->recieveType = isset($row['recieveType']) ? $row['recieveType'] : '';
        $storemovement->recieveUserid = isset($row['recieveUserid']) ? $row['recieveUserid'] : '';
        $storemovement->recieveTime = isset($row['recieveTime']) ? $row['recieveTime'] : '';
        $storemovement->operationnum = isset($row['operationnum']) ? $row['operationnum'] : '';
        $storemovement->deloperationnum = isset($row['deloperationnum']) ? $row['deloperationnum'] : '';
        $storemovement->oprationnumber = isset($row['oprationnumber']) ? $row['oprationnumber'] : '';
        $storemovement->driverid = isset($row['driverid']) ? $row['driverid'] : '';
        $storemovement->drivertimeout = isset($row['drivertimeout']) ? $row['drivertimeout'] : '';
        $storemovement->driverdate = isset($row['driverdate']) ? $row['driverdate'] : '';
        $storemovement->delivererid = isset($row['delivererid']) ? $row['delivererid'] : '';
        $storemovement->deliverdate = isset($row['deliverdate']) ? $row['deliverdate'] : '';
        $storemovement->priceType = isset($row['priceType']) ? $row['priceType'] : '';
        $storemovement->price = isset($row['price']) ? $row['price'] : '';
        $storemovement->sizeid = isset($row['sizeid']) ? $row['sizeid'] : '';
        $storemovement->colorid = isset($row['colorid']) ? $row['colorid'] : '';
        $storemovement->expireDate = isset($row['expireDate']) ? $row['expireDate'] : '';
        $storemovement->expireDateTo = isset($row['expireDateTo']) ? $row['expireDateTo'] : '';
        $storemovement->buyPricesHistoryBookData = isset($row['buyPricesHistoryBookData']) ? $row['buyPricesHistoryBookData'] : '';


        //required
        $storemovement->storefromName = isset($row['storefromName']) ? $row['storefromName'] : '';
        $storemovement->storetoName = isset($row['storetoName']) ? $row['storetoName'] : '';
        $storemovement->productName = isset($row['productName']) ? $row['productName'] : '';
        $storemovement->productCatName = isset($row['productCatName']) ? $row['productCatName'] : '';
        $storemovement->productquantity = isset($row['productquantity']) ? $row['productquantity'] : '';
        $storemovement->lateHours = isset($row['lateHours']) ? $row['lateHours'] : '';
        $storemovement->storetype = isset($row['storetype']) ? $row['storetype'] : '';
        $storemovement->employeename = isset($row['employeename']) ? $row['employeename'] : '';
        $storemovement->recieveUserName = isset($row['recieveUserName']) ? $row['recieveUserName'] : '';
        //eman
        $storemovement->parcode = isset($row['parcode']) ? $row['parcode'] : '';
        $storemovement->userPrepared = isset($row['userPrepared']) ? $row['userPrepared'] : '';
        $storemovement->isPrepared = isset($row['isPrepared']) ? $row['isPrepared'] : '';
        $storemovement->useridPrepared = isset($row['useridPrepared']) ? $row['useridPrepared'] : '';
        $storemovement->dailyentryid = isset($row['dailyentryid']) ? $row['dailyentryid'] : '';




        return $storemovement;
    }

    protected function getList($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return StoremovementMySql
     */
    protected function getRow($sqlQuery)
    {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery)
    {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery)
    {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery)
    {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery)
    {
        return QueryExecutor::executeInsert($sqlQuery);
    }
}
