<?php

/**
 * Class that operate on table 'branch'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-09-10 14:26
 */
class TypeClientMySqlDAO implements TypeClientDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return typeMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM typeclient WHERE typeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM typeclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM typeclient ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param type primary key
     */
    public function delete($typeId) {
        $sql = 'DELETE FROM typeclient WHERE typeId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($typeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param typeMySql type
     */
    public function insert($type) {
        $sql = 'INSERT INTO typeclient (typeName, typeDate,conditions,comments,webApiId) VALUES (?,?,?,?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($type->typeName);
        $sqlQuery->set($type->typeDate);
        $sqlQuery->setNumber($type->conditions);
        $sqlQuery->set($type->comments);
        $sqlQuery->setNumber((int) $type->webApiId);


        $id = $this->executeInsert($sqlQuery);
        $type->typeId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param typeMySql type
     */
    public function update($type) {
        $sql = 'UPDATE typeclient SET typeName = ?, typeDate = ? , conditions = ? , comments = ? WHERE typeId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($type->typeName);
        $sqlQuery->set($type->typeDate);
        $sqlQuery->setNumber($type->conditions);
        $sqlQuery->set($type->comments);

        $sqlQuery->setNumber($type->typeId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM typeclient';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByTypeName($value) {
        $sql = 'SELECT * FROM typeclient WHERE typeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByTypeDate($value) {
        $sql = 'SELECT * FROM typeclient WHERE typeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByTypeName($value) {
        $sql = 'DELETE FROM typeclient WHERE typeName = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByTypeDate($value) {
        $sql = 'DELETE FROM typeclient WHERE typeDate = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return typeMySql
     */
    protected function readRow($row) {
        $type = new TypeClient();

        $type->typeId = isset($row['typeId']) ? $row['typeId'] : '';
        $type->typeName = isset($row['typeName']) ? $row['typeName'] : '';
        $type->typeDate = isset($row['typeDate']) ? $row['typeDate'] : '';
        $type->conditions = isset($row['conditions']) ? $row['conditions'] : '';
        $type->comments = isset($row['comments']) ? $row['comments'] : '';
        $type->webApiId = isset($row['webApiId']) ? $row['webApiId'] : '';

        return $type;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return typeMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>