<?php

/**
 * Class that operate on table 'workstationworker'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2014-04-01 11:09
 */
class WorkstationworkerMySqlDAO implements WorkstationworkerDAO {

    /**
     * Get Domain object by primry key
     *
     * @param String $id primary key
     * @return WorkstationworkerMySql
     */
    public function load($id) {
        $sql = 'SELECT * FROM workstationworker WHERE workstationworkerId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($id);
        return $this->getRow($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAll() {
        $sql = 'SELECT * FROM workstationworker';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Get all records from table ordered by field
     *
     * @param $orderColumn column name
     */
    public function queryAllOrderBy($orderColumn) {
        $sql = 'SELECT * FROM workstationworker ORDER BY ' . $orderColumn;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    /**
     * Delete record from table
     * @param workstationworker primary key
     */
    public function delete($workstationworkerId) {
        $sql = 'DELETE FROM workstationworker WHERE workstationworkerId = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($workstationworkerId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Insert record to table
     *
     * @param WorkstationworkerMySql workstationworker
     */
    public function insert($workstationworker) {
        $sql = 'INSERT INTO workstationworker (workstationid, employeeid, workhours, efficiency) VALUES (?, ?, ?, ?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($workstationworker->workstationid);
        $sqlQuery->set($workstationworker->employeeid);
        $sqlQuery->set($workstationworker->workhours);
        $sqlQuery->set($workstationworker->efficiency);

        $id = $this->executeInsert($sqlQuery);
        $workstationworker->workstationworkerId = $id;
        return $id;
    }

    /**
     * Update record in table
     *
     * @param WorkstationworkerMySql workstationworker
     */
    public function update($workstationworker) {
        $sql = 'UPDATE workstationworker SET workstationid = ?, employeeid = ?, workhours = ?, efficiency = ?,  WHERE workstationworkerId = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($workstationworker->workstationid);
        $sqlQuery->set($workstationworker->employeeid);
        $sqlQuery->set($workstationworker->workhours);
        $sqlQuery->set($workstationworker->efficiency);

        $sqlQuery->setNumber($workstationworker->workstationworkerId);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Delete all rows
     */
    public function clean() {
        $sql = 'DELETE FROM workstationworker';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryByWorkstationid($value) {
        $sql = 'SELECT * FROM workstationworker WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEmployeeid($value) {
        $sql = 'SELECT * FROM workstationworker WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function queryByWorkhours($value) {
        $sql = 'SELECT * FROM workstationworker WHERE workhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function queryByEfficiency($value) {
        $sql = 'SELECT * FROM workstationworker WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getList($sqlQuery);
    }

    public function deleteByWorkstationid($value) {
        $sql = 'DELETE FROM workstationworker WHERE workstationid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEmployeeid($value) {
        $sql = 'DELETE FROM workstationworker WHERE employeeid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByWorkhours($value) {
        $sql = 'DELETE FROM workstationworker WHERE workhours = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    public function deleteByEfficiency($value) {
        $sql = 'DELETE FROM workstationworker WHERE efficiency = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Read row
     *
     * @return WorkstationworkerMySql
     */
    protected function readRow($row) {
        $workstationworker = new Workstationworker();

        $workstationworker->workstationworkerId = isset($row['workstationworkerId']) ? $row['workstationworkerId'] : '';
        $workstationworker->workstationid = isset($row['workstationid']) ? $row['workstationid'] : '';
        $workstationworker->workhours = isset($row['workhours']) ? $row['workhours'] : '';
        $workstationworker->efficiency = isset($row['efficiency']) ? $row['efficiency'] : '';
        $workstationworker->employeeid = isset($row['employeeId']) ? $row['employeeId'] : '';

        $workstationworker->employeeName = isset($row['employeeName']) ? $row['employeeName'] : '';
        $workstationworker->Hourlyrate = isset($row['Hourlyrate']) ? $row['Hourlyrate'] : '';
        $workstationworker->workname = isset($row['workname']) ? $row['workname'] : '';
        $workstationworker->settingOperationrealTime = isset($row['settingOperationrealTime']) ? $row['settingOperationrealTime'] : '';

        return $workstationworker;
    }

    protected function getList($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        $ret = array();
        for ($i = 0; $i < count($tab); $i++) {
            $ret[$i] = $this->readRow($tab[$i]);
        }
        return $ret;
    }

    /**
     * Get row
     *
     * @return WorkstationworkerMySql
     */
    protected function getRow($sqlQuery) {
        $tab = QueryExecutor::execute($sqlQuery);
        if (count($tab) == 0) {
            return null;
        }
        return $this->readRow($tab[0]);
    }

    /**
     * Execute sql query
     */
    protected function execute($sqlQuery) {
        return QueryExecutor::execute($sqlQuery);
    }

    /**
     * Execute sql query
     */
    protected function executeUpdate($sqlQuery) {
        return QueryExecutor::executeUpdate($sqlQuery);
    }

    /**
     * Query for one row and one column
     */
    protected function querySingleResult($sqlQuery) {
        return QueryExecutor::queryForString($sqlQuery);
    }

    /**
     * Insert row to table
     */
    protected function executeInsert($sqlQuery) {
        return QueryExecutor::executeInsert($sqlQuery);
    }

}

?>