<?php

/**
 * Class that operate on table 'expensestype'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class ExpensestypeMySqlExtDAO extends ExpensestypeMySqlDAO {

    public function getExtepensesTypeParents() {
        $sql = 'SELECT *
		FROM expensestype
		WHERE parent = 0
		AND conditions = 0';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }


     public function expensetypesave($queryString = '') {
        $sql = 'SELECT expensestype.* FROM expensestype WHERE expensestype.conditions = 0 ' . $queryString . ' limit 1000';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }



     public function queryWithConditionWithQueryString($queryString = '') {
        $sql = 'SELECT expensestype.* FROM expensestype WHERE expensestype.conditions = 0 ' . $queryString . ' ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function getTypesWithoutExpenses($queryString = '') {
        $sql = 'SELECT expensestype.*
		FROM expensestype
                left join expenses on expenses.expensestypeid = expensestype.expensestypeid
		WHERE expenses.expensestypeid is null
		AND expensestype.conditions = 0 ' . $queryString;
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithLimit($startpoint, $perpage) {
        $sql = 'SELECT *
		FROM expensestype
		WHERE conditions=0
		ORDER BY expensestypeid DESC
		limit ' . $startpoint . ',' . $perpage . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllForShow() {
        $sql = 'SELECT *
		FROM expensestype
		WHERE conditions=0
		ORDER BY expensestypeid DESC ';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithname($startpoint, $perpage, $name) {
        $sql = "SELECT *
		FROM expensestype
		WHERE conditions=0
		and expensestypename like '" . $name . "%'
		ORDER BY expensestypeid DESC limit " . $startpoint . "," . $perpage . "";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllname($name) {
        $sql = "SELECT * FROM expensestype WHERE conditions=0 and expensestypename like '" . $name . "%' ORDER BY expensestypeid DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateConditions($expensestype) {
        $sql = 'UPDATE expensestype SET expensestypedate = ?, conditions = ?, userid = ? WHERE expensestypeid = ?';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->set($expensestype->expensestypedate);
        $sqlQuery->setNumber($expensestype->conditions);
        $sqlQuery->setNumber($expensestype->userid);

        $sqlQuery->setNumber($expensestype->expensestypeid);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllExt() {
        $sql = "SELECT *
		 FROM expensestype
		 WHERE conditions=0
		 ORDER BY expensestypeid DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllExtNotParent() {
        $sql = "SELECT expensestype.*,theParent.expensestypename as parentexpensestypename
		 FROM expensestype
                 left join expensestype theParent on expensestype.parent=theParent.expensestypeid
                 left join expensestype child on expensestype.expensestypeid = child.parent
		 WHERE expensestype.conditions=0
                 and child.expensestypeid is Null
		 ORDER BY expensestype.expensestypeid DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

//query all expenses types that have no child types
    public function queryAllChildren() {
        $sql = "SELECT DISTINCT(a.expensestypeid) , a.*
		 FROM expensestype a, expensestype b
		 WHERE a.conditions=0
		 AND b.conditions=0
		 AND a.expensestypeid <> b.parent
		 AND b.parent <> 0
		 ORDER BY a.expensestypeid DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

//query all expenses types that have no child types
    public function queryAllTypesWithNoChildren() {
        $sql = "SELECT *
		 FROM expensestype
		 WHERE conditions=0
		 AND expensestypeid  NOT IN
		 (
		 	SELECT DISTINCT (parent)
			FROM expensestype
		 	WHERE conditions=0
		 )
		 ORDER BY expensestypeid DESC ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query last expenses types (which have parents) in the hierarcy
    public function queryAllChildrenExt() {
        $sql = "SELECT DISTINCT(a.expensestypeid) , a.*
		 FROM expensestype a, expensestype b
		 WHERE a.conditions=0
		 AND b.conditions=0
		 AND a.expensestypeid <> b.parent
		 AND a.parent <> 0
         AND a.expensestypeid NOT IN (
              SELECT parent
			  FROM expensestype
			  WHERE conditions = 0
			  AND parent <> 0
           )
		 ORDER BY a.expensestypeid DESC  ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    //query last expenses types(which not necessarily have a parent) in the hierarcy
    public function queryAllChildrenExt2() {
        $sql = "SELECT DISTINCT(a.expensestypeid) , a.*
		 FROM expensestype a
		 WHERE a.conditions=0
		 AND a.expensestypeid
         AND a.expensestypeid NOT IN (
              SELECT parent
			  FROM expensestype
			  WHERE conditions = 0
			  AND parent <> 0
           )
		 ORDER BY a.expensestypeid DESC  ";
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryByParentExt($expenseTypeId) {
        $sql = 'SELECT *
		FROM expensestype
		WHERE parent = ?
		AND conditions=0';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($expenseTypeId);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithSave($saveid) {
        $sql = 'SELECT * FROM expensestype ';
        if ($saveid != 0) {
            $sql .= 'where (saveid = ' . $saveid . ' or  saveid = 0 )';
        }
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithSaveNotParent($saveid) {
        $sql = 'SELECT expensestype.*,theParent.expensestypename as parentexpensestypename
                FROM expensestype
                left join expensestype theParent on expensestype.parent=theParent.expensestypeid
                left join expensestype child on expensestype.expensestypeid = child.parent
                where expensestype.conditions=0 AND child.expensestypeid is null ';
        if ($saveid != 0) {
            $sql .= 'and (expensestype.saveid = ' . $saveid . ' or  expensestype.saveid = 0 )';
        }
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function sumOfEachTypeQueryString($queryString = '') {
        $sql = 'SELECT expensestype.expensestypename,expensestype.conditions,sum(expenses.expensesValue) as sumExpensesValue
				FROM expensestype
				join expenses
				on expensestype.expensestypeid = expenses.expensestypeid
				where expenses.conditions = 0
                                    ' . $queryString . '
				group by expensestype.expensestypeid '; //expensestype.conditions = 0

        $sqlQuery = new SqlQuery($sql);
        //print_r($sql);
        return $this->getList($sqlQuery);
    }

    public function sumOfEachTypeQuery($expensesdate = '') {
        $sql = 'SELECT expensestype.expensestypename,expensestype.conditions,sum(expenses.expensesValue) as sumExpensesValue
				FROM expensestype
				join expenses
				on expensestype.expensestypeid = expenses.expensestypeid
				where expenses.conditions = 0 ' . $expensesdate . '
				group by expensestype.expensestypeid '; //expensestype.conditions = 0

        $sqlQuery = new SqlQuery($sql);
        // print_r($sql);
        return $this->getList($sqlQuery);
    }

}

?>