<?php

/**
 * Class that operate on table 'kashf'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2016-06-21 12:09
 */
class KashfMySqlExtDAO extends KashfMySqlDAO {

    public function loadKashf($customerid, $datetoday) {

        $sql = 'SELECT * FROM kashf WHERE customerid=? and kashfdate=? limit 1';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($customerid);
        $sqlQuery->set($datetoday);
        return $this->getRow($sqlQuery);
    }

    public function loadAllByDate($datetoday) {

        $sql = 'SELECT * FROM kashf WHERE kashfdate=? and entered=0 ';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($datetoday);
        return $this->getList($sqlQuery);
    }

    public function getDocClientName($kasfhId) {
        $sql = 'SELECT kashf .* ,client.clientname as clientname,user.username as docname
            from kashf
            join client on client.clientid = kashf.customerid
            join user on user.userid = kashf.doctorid
            where kashf.id=' . $kasfhId . ' and kashf.entered=0
';
        $sqlQuery = new SqlQuery($sql);

        return $this->getRow($sqlQuery);
    }

    public function queryByRondomtxt($value) {
        $sql = 'SELECT * FROM kashf WHERE rondomtxt = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->set($value);
        return $this->getRow($sqlQuery);
    }

    public function queryAllDESC() {
        $sql = 'SELECT * FROM kashf ORDER BY id DESC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function markKashfAsUsed($id) {
        $sql = 'UPDATE kashf SET used = 1 WHERE id = ' . $id . '';
        $sqlQuery = new SqlQuery($sql);

        return $this->executeUpdate($sqlQuery);
    }

}

?>