<?php

/**
 * Class that operate on table 'movementmanage'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2013-04-06 10:57
 */
class MovementmanageMySqlExtDAO extends MovementmanageMySqlDAO {

    public function dropdatabase($mydatabase) {
        $sql = 'DROP DATABASE  ' . $mydatabase . '   ';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllWithLimited($start, $end) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
                 where movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithoutLimited() {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
                 where movementmanage.userid > 0
		order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDate($startDate, $endDate) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
                    and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDateLimited($start, $end, $startDate, $endDate) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithUserid($userid) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where  movementmanage.userid = ' . $userid . '
                    and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithUseridLimited($start, $end, $userid) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where  movementmanage.userid = ' . $userid . '
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOperationname($operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where  movementmanage.operationname = "' . $operationname . '"
                    and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryWithOperationnameLimited($start, $end, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where  movementmanage.operationname = "' . $operationname . '"
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDateAndUser($startDate, $endDate, $userid) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
		 and movementmanage.userid = ' . $userid . '
                     and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDateAndUserLimited($start, $end, $startDate, $endDate, $userid) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
		and movementmanage.userid = ' . $userid . '
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDateAndOperationname($startDate, $endDate, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
		 and  movementmanage.operationname = "' . $operationname . '"
                     and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithDateAndOperationnameLimited($start, $end, $startDate, $endDate, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
		and  movementmanage.operationname = "' . $operationname . '"
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithUserAndOperationname($userid, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where movementmanage.userid = ' . $userid . '
		 and  movementmanage.operationname = "' . $operationname . '"
                     and movementmanage.userid > 0
		 order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithUserAndOperationnameLimited($start, $end, $userid, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where movementmanage.userid = ' . $userid . '
		and  movementmanage.operationname = "' . $operationname . '"
                    and movementmanage.userid > 0
		order by movementmanageid desc limit ' . $start . ',' . $end . '';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function deleteByMovementmanagedateEX($startDate, $endDate) {
        $sql = 'DELETE FROM movementmanage WHERE DATE(movementmanagedate) >= "' . $startDate . '" and DATE(movementmanagedate) <= "' . $endDate . '" and movementmanage.userid > 0 ';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function queryAllWithOpnameAndDateSimple($startDate, $endDate) {
        $sql = 'select * FROM movementmanage WHERE DATE(movementmanagedate) >= "' . $startDate . '" and DATE(movementmanagedate) <= "' . $endDate . '" and movementmanage.userid > 0 order by movementmanageid asc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithOpnameAndDate($startDate, $endDate) {
        $sql = 'SELECT movementmanage.*, count(movementmanage.userid) as cs , user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where movementmanage.operationname = "index.php"
                and date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
                    and movementmanage.userid > 0
                group by movementmanage.userid,date(movementmanagedate)
                order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithUserAndOperationnameGrouped($userid, $operationname) {
        $sql = 'SELECT movementmanage.*, user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where movementmanage.userid = ' . $userid . '
		 and  movementmanage.operationname = "' . $operationname . '"
                     and movementmanage.userid > 0
		 group by date(movementmanagedate)
                order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function queryAllWithOpnameAndDateAndUserGrouped($startDate, $endDate, $userid) {
        $sql = 'SELECT movementmanage.*, count(movementmanage.userid) as cs , user.username
		 FROM movementmanage JOIN user
		 ON movementmanage.userid = user.userid
		where movementmanage.userid = ' . $userid . '
		 and movementmanage.operationname = "index.php"
                and date(movementmanagedate) >= "' . $startDate . '" and date(movementmanagedate) <= "' . $endDate . '"
                    and movementmanage.userid > 0
                group by movementmanage.userid,date(movementmanagedate)
                order by movementmanageid desc';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

}

?>