<?php

/**
 * Class that operate on table 'productionoutmanyinproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyinproductsMySqlExtDAO extends ProductionoutmanyinproductsMySqlDAO {

    public function queryByProductionOutManyIdEX($value) {
        $sql = 'SELECT productionoutmanyinproducts.*,product.productName,productcat.productCatName,size.name as sizeName,color.name as colorName
                ,productunit.productnumber,unit.unitName
                FROM productionoutmanyinproducts
                JOIN product	ON product.productId = productionoutmanyinproducts.productid
                JOIN productcat ON product.productCatId = productcat.productCatId
                left join sizecolor as size ON size.id=productionoutmanyinproducts.sizeid
                left join sizecolor as color ON color.id=productionoutmanyinproducts.colorid
                join productunit ON productunit.productunitid=productionoutmanyinproducts.prounitid
                join unit ON unit.unitId=productunit.unitid
                WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($productionoutmanyinproduct) {
        $sql = 'INSERT INTO productionoutmanyinproducts (id,productionoutmanyid, productid, sizeid, colorid, prounitid, quantity, unitpriceraw, unitManufPrice, inTotalCostUnit, inTotalCost) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyinproduct->id);
        $sqlQuery->setNumber($productionoutmanyinproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyinproduct->productid);
        $sqlQuery->setNumber($productionoutmanyinproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyinproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyinproduct->prounitid);
        $sqlQuery->set($productionoutmanyinproduct->quantity);
        $sqlQuery->set($productionoutmanyinproduct->unitpriceraw);
        $sqlQuery->set($productionoutmanyinproduct->unitManufPrice);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCostUnit);
        $sqlQuery->set($productionoutmanyinproduct->inTotalCost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmanyinproduct->id = $id;
        return $id;
    }

}

?>