<?php

/**
 * Class that operate on table 'productionoutmanyoutproducts'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2023-01-24 21:04
 */
class ProductionoutmanyoutproductsMySqlExtDAO extends ProductionoutmanyoutproductsMySqlDAO {

    public function queryByProductionOutManyIdEX($value) {
        $sql = 'SELECT productionoutmanyoutproducts.*,product.productName,productcat.productCatName,size.name as sizeName,color.name as colorName
                ,productunit.productnumber,unit.unitName
                FROM productionoutmanyoutproducts
                JOIN product	ON product.productId = productionoutmanyoutproducts.productid
                JOIN productcat ON product.productCatId = productcat.productCatId
                left join sizecolor as size ON size.id=productionoutmanyoutproducts.sizeid
                left join sizecolor as color ON color.id=productionoutmanyoutproducts.colorid
                join productunit ON productunit.productunitid=productionoutmanyoutproducts.prounitid
                join unit ON unit.unitId=productunit.unitid
                WHERE productionoutmanyid = ?';
        $sqlQuery = new SqlQuery($sql);
        $sqlQuery->setNumber($value);
        return $this->getList($sqlQuery);
    }

    public function insertWithId($productionoutmanyoutproduct) {
        $sql = 'INSERT INTO productionoutmanyoutproducts (id,productionoutmanyid, productid, sizeid, colorid, prounitid, quantity, unitprice, cost) VALUES (?, ?, ?, ?, ?, ?, ?, ?,?)';
        $sqlQuery = new SqlQuery($sql);

        $sqlQuery->setNumber($productionoutmanyoutproduct->id);
        $sqlQuery->setNumber($productionoutmanyoutproduct->productionoutmanyid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->productid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->sizeid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->colorid);
        $sqlQuery->setNumber($productionoutmanyoutproduct->prounitid);
        $sqlQuery->set($productionoutmanyoutproduct->quantity);
        $sqlQuery->set($productionoutmanyoutproduct->unitprice);
        $sqlQuery->set($productionoutmanyoutproduct->cost);

        $id = $this->executeInsert($sqlQuery);
        $productionoutmanyoutproduct->id = $id;
        return $id;
    }

}

?>