<?php

/**
 * Class that operate on table 'usergroupadmin'. Database Mysql.
 *
 * @author: http://phpdao.com
 * @date: 2020-02-26 15:13
 */
class UsergroupadminMySqlExtDAO extends UsergroupadminMySqlDAO {

    /**
     * this is to add any new properity with its default value
     */
    public function insertSpecial() {
        $sql = 'INSERT IGNORE INTO usergroupadmin (propertyid, isallowed)
                SELECT propertyid , propertydefault
                from properties';
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    public function getCount() {
        $sql = 'select count(id) from usergroupadmin';
        $sqlQuery = new SqlQuery($sql);
        return $this->querySingleResult($sqlQuery);
    }

    public function setIsAllowedLikeGroupAdmin() {
        $sql = "UPDATE usergroupadmin
                INNER JOIN relusergroupproperties ON (usergroupadmin.propertyid = relusergroupproperties.propertyid and relusergroupproperties.usergroupid = 1)
                SET usergroupadmin.isallowed = relusergroupproperties.propertyvalue";
        $sqlQuery = new SqlQuery($sql);
        return $this->executeUpdate($sqlQuery);
    }

    /**
     * Get all records from table
     */
    public function queryAllEX() {
        $sql = 'SELECT usergroupadmin.*,properties.propertyname, properties.propertyparent
                FROM usergroupadmin
                join properties on properties.propertyid = usergroupadmin.propertyid
                ORDER BY case when properties.propertyparent=0 then properties.propertyid else properties.propertyparent end * 1000 + properties.propertyid ASC';
        $sqlQuery = new SqlQuery($sql);
        return $this->getList($sqlQuery);
    }

    public function updateBulk($sql) {
        $sqlQuery = new SqlQuery($sql);
        $affected_rows = $this->executeUpdate($sqlQuery, 1);
        return $affected_rows;
    }

}

?>